/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.silverminer.shrines.random_variation.RandomVariationConfig;
import com.silverminer.shrines.structures.ShrinesJigsawPlacement;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class VariationCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_CONFIG = new DynamicCommandExceptionType(o -> new TranslatableComponent("commands.variate.invalid.config", new Object[]{o}));
    private static final DynamicCommandExceptionType ERROR_INVALID_TEMPLATE = new DynamicCommandExceptionType(o -> new TranslatableComponent("commands.variate.invalid.template", new Object[]{o}));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"variate").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"existing").then(Commands.m_82129_((String)"config", (ArgumentType)ResourceKeyArgument.m_212386_(RandomVariationConfig.REGISTRY)).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(commandContext -> VariationCommand.variate((CommandSourceStack)commandContext.getSource(), VariationCommand.getVariationConfig((CommandContext<CommandSourceStack>)commandContext, "config"), BlockPosArgument.m_118242_((CommandContext)commandContext, (String)"from"), BlockPosArgument.m_118242_((CommandContext)commandContext, (String)"to")))))))).then(Commands.m_82127_((String)"template").then(Commands.m_82129_((String)"template", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"structurePos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"config", (ArgumentType)ResourceKeyArgument.m_212386_(RandomVariationConfig.REGISTRY)).executes(context -> VariationCommand.loadAndVariate((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"template"), BlockPosArgument.m_118242_((CommandContext)context, (String)"structurePos"), VariationCommand.getVariationConfig((CommandContext<CommandSourceStack>)context, "config")))))))).then(Commands.m_82127_((String)"jigsaw").then(Commands.m_82129_((String)"startPool", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registry.f_122884_)).then(Commands.m_82129_((String)"maxDepth", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).then(Commands.m_82129_((String)"keepJigsaws", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"structurePos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"config", (ArgumentType)ResourceKeyArgument.m_212386_(RandomVariationConfig.REGISTRY)).executes(context -> VariationCommand.loadJigsawAndVariate(((CommandSourceStack)context.getSource()).m_81372_(), VariationCommand.getTemnplatePool((CommandContext<CommandSourceStack>)context, "startPool"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxDepth"), BoolArgumentType.getBool((CommandContext)context, (String)"keepJigsaws"), BlockPosArgument.m_118242_((CommandContext)context, (String)"structurePos"), VariationCommand.getVariationConfig((CommandContext<CommandSourceStack>)context, "config"))))))))));
    }

    private static int variate(CommandSourceStack source, RandomVariationConfig config, BlockPos from, BlockPos to) {
        BoundingBox box = BoundingBox.m_162375_((Vec3i)from, (Vec3i)to);
        config.process((WorldGenLevel)source.m_81372_(), VariationCommand.createRandom(), box, box, arg_0 -> ((BoundingBox)box).m_71051_(arg_0));
        return 0;
    }

    private static int loadAndVariate(CommandSourceStack source, ResourceLocation template, BlockPos structurePos, RandomVariationConfig config) {
        Optional optional;
        StructureManager structuremanager = source.m_81372_().m_8875_();
        try {
            optional = structuremanager.m_163774_(template);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return -1;
        }
        if (optional.isEmpty()) {
            return -1;
        }
        Random random = VariationCommand.createRandom();
        StructureTemplate structureTemplate = (StructureTemplate)optional.get();
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
        structureTemplate.m_74536_((ServerLevelAccessor)source.m_81372_(), structurePos, structurePos, structureplacesettings, random, 2);
        BoundingBox box = structureTemplate.m_74633_(structureplacesettings, structurePos);
        config.process((WorldGenLevel)source.m_81372_(), random, box, box, arg_0 -> ((BoundingBox)box).m_71051_(arg_0));
        return 0;
    }

    private static Random createRandom() {
        return new Random(Util.m_137550_());
    }

    private static int loadJigsawAndVariate(ServerLevel serverLevel, StructureTemplatePool structureTemplatePool, int maxDepth, boolean keepJigsaws, BlockPos structurePos, RandomVariationConfig config) {
        ChunkGenerator chunkgenerator = serverLevel.m_7726_().m_8481_();
        StructureManager structuremanager = serverLevel.m_8875_();
        StructureFeatureManager structurefeaturemanager = serverLevel.m_8595_();
        Random random = serverLevel.m_5822_();
        ArrayList list = Lists.newArrayList();
        StructurePoolElement structurepoolelement = structureTemplatePool.m_210585_(random);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuremanager, structurepoolelement, structurePos, 1, Rotation.NONE, structurepoolelement.m_207470_(structuremanager, structurePos, Rotation.NONE));
        list.add(poolelementstructurepiece);
        ShrinesJigsawPlacement.addPieces(serverLevel.m_5962_(), poolelementstructurepiece, maxDepth, PoolElementStructurePiece::new, chunkgenerator, structuremanager, list, random, (LevelHeightAccessor)serverLevel);
        for (PoolElementStructurePiece poolelementstructurepiece1 : list) {
            poolelementstructurepiece1.m_192416_((WorldGenLevel)serverLevel, structurefeaturemanager, chunkgenerator, random, BoundingBox.m_71044_(), structurePos, keepJigsaws);
        }
        if (list.isEmpty()) {
            return 0;
        }
        PiecesContainer container = new PiecesContainer(list.stream().map(o -> o).toList());
        BoundingBox box = container.m_192756_();
        config.process((WorldGenLevel)serverLevel, random, box, box, arg_0 -> ((PiecesContainer)container).m_192751_(arg_0));
        return 0;
    }

    private static RandomVariationConfig getVariationConfig(CommandContext<CommandSourceStack> commandContext, String literal) throws CommandSyntaxException {
        ResourceKey resourcekey = VariationCommand.getRegistryType(commandContext, literal, RandomVariationConfig.REGISTRY, ERROR_INVALID_CONFIG);
        return (RandomVariationConfig)((Object)((CommandSourceStack)commandContext.getSource()).m_81372_().m_142572_().m_206579_().m_175515_(RandomVariationConfig.REGISTRY).m_123009_(resourcekey).orElseThrow(() -> ERROR_INVALID_CONFIG.create((Object)resourcekey.m_135782_())));
    }

    private static StructureTemplatePool getTemnplatePool(CommandContext<CommandSourceStack> commandContext, String literal) throws CommandSyntaxException {
        ResourceKey resourcekey = VariationCommand.getRegistryType(commandContext, literal, Registry.f_122884_, ERROR_INVALID_TEMPLATE);
        return (StructureTemplatePool)((CommandSourceStack)commandContext.getSource()).m_81372_().m_142572_().m_206579_().m_175515_(Registry.f_122884_).m_123009_(resourcekey).orElseThrow(() -> ERROR_INVALID_TEMPLATE.create((Object)resourcekey.m_135782_()));
    }

    private static <T> ResourceKey<T> getRegistryType(CommandContext<CommandSourceStack> commandContext, String literal, ResourceKey<Registry<T>> registryKey, DynamicCommandExceptionType exceptionType) throws CommandSyntaxException {
        ResourceKey resourcekey = (ResourceKey)commandContext.getArgument(literal, ResourceKey.class);
        Optional optional = resourcekey.m_195975_(registryKey);
        return (ResourceKey)optional.orElseThrow(() -> exceptionType.create((Object)resourcekey));
    }
}

